package ru.yandex.direct.core.entity.banner.type.image;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithImageAndCreative;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithImageAndCreativeUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithImageAndCreative> {

    private final BannerWithImageAndCreativeValidatorProvider validatorProvider;

    @Autowired
    public BannerWithImageAndCreativeUpdateValidationTypeSupport(
            BannerWithImageAndCreativeValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithImageAndCreative> getTypeClass() {
        return BannerWithImageAndCreative.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<BannerWithImageAndCreative>>, Defect> validateBeforeApply(
            BannersUpdateOperationContainer container,
            ValidationResult<List<ModelChanges<BannerWithImageAndCreative>>, Defect> vr,
            Map<Long, BannerWithImageAndCreative> unmodifiedModels) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(
                        validatorProvider.imageAndCreativeModificationValidator(unmodifiedModels))
                .getResult();
    }

    @Override
    public ValidationResult<List<BannerWithImageAndCreative>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithImageAndCreative>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.imageAndCreativeValidator())
                .getResult();
    }
}
