package ru.yandex.direct.core.entity.banner.type.image;

import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithImageAndCreative;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelChangesValidationBuilder;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.type.image.BannerWithImageConstraints.creativeNotChangedToImage;
import static ru.yandex.direct.core.entity.banner.type.image.BannerWithImageConstraints.imageNotChangedToCreative;
import static ru.yandex.direct.core.entity.banner.type.image.BannerWithImageConstraints.imageOrCreativeIsSet;
import static ru.yandex.direct.core.entity.banner.type.image.BannerWithImageConstraints.onlyImageOrCreativeIdIsSet;

@Component
public class BannerWithImageAndCreativeValidatorProvider {


    public Validator<ModelChanges<BannerWithImageAndCreative>, Defect> imageAndCreativeModificationValidator(
            Map<Long, BannerWithImageAndCreative> unmodifiedModels) {
        return mc -> {

            ModelChangesValidationBuilder<BannerWithImageAndCreative> vb = ModelChangesValidationBuilder.of(mc);

            vb
                    .check(imageNotChangedToCreative(unmodifiedModels))
                    .check(creativeNotChangedToImage(unmodifiedModels));
            return vb.getResult();
        };
    }

    Validator<BannerWithImageAndCreative, Defect> imageAndCreativeValidator() {
        return banner -> {
            ModelItemValidationBuilder<BannerWithImageAndCreative> vb = ModelItemValidationBuilder.of(banner);

            vb
                    .check(imageOrCreativeIsSet())
                    .check(onlyImageOrCreativeIdIsSet(), When.isValid());

            return vb.getResult();
        };
    }
}
