package ru.yandex.direct.core.entity.banner.type.image;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersModerationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithImage;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.type.image.BannerWithImageUtils.isImageChanged;

@Component
public class BannerWithImageUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithImage> {

    @Override
    public Class<BannerWithImage> getTypeClass() {
        return BannerWithImage.class;
    }

    @Override
    public boolean needModeration(BannersModerationContainer container,
                                  AppliedChanges<BannerWithImage> appliedChanges) {
        return isImageChanged(appliedChanges);
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithImage> appliedChanges) {
        return isImageChanged(appliedChanges);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithImage> appliedChanges) {
        return isImageChanged(appliedChanges);
    }
}
