package ru.yandex.direct.core.entity.banner.type.image;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithImage;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.image.BannerWithImageConstraints.isMobileImageNotChanged;

@Component
public class BannerWithImageUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithImage> {

    private final BannerWithImageValidatorProvider validatorProvider;

    @Autowired
    public BannerWithImageUpdateValidationTypeSupport(
            BannerWithImageValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithImage> getTypeClass() {
        return BannerWithImage.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<BannerWithImage>>, Defect> validateBeforeApply(
            BannersUpdateOperationContainer container,
            ValidationResult<List<ModelChanges<BannerWithImage>>, Defect> vr,
            Map<Long, BannerWithImage> unmodifiedModels) {

        var existingSizes = container.getExistingImageTypesWithSizesBeforeApply();

        return new ListValidationBuilder<>(vr)
                .checkEachBy(
                        validatorProvider.imageModificationValidator(existingSizes, unmodifiedModels))
                .checkEach(isMobileImageNotChanged(unmodifiedModels))
                .getResult();
    }

    @Override
    public ValidationResult<List<BannerWithImage>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithImage>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.imageValidator(container))
                .getResult();
    }

}
