package ru.yandex.direct.core.entity.banner.type.image;

import java.util.Map;

import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.core.entity.banner.model.BannerWithImage;
import ru.yandex.direct.core.entity.banner.model.ImageSize;
import ru.yandex.direct.core.entity.banner.model.ImageType;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelChangesValidationBuilder;

import static ru.yandex.direct.core.entity.banner.type.image.BannerWithImageConstraints.imageSizeIsNotChanged;

public class NewImageModificationValidator implements Validator<ModelChanges<BannerWithImage>, Defect> {

    private final Map<String, Pair<ImageType, ImageSize>> imageHashToTypeWithSize;
    private final Map<Long, BannerWithImage> unmodifiedModels;

    public NewImageModificationValidator(Map<String, Pair<ImageType, ImageSize>> imageHashToTypeWithSize,
                                               Map<Long, BannerWithImage> unmodifiedModels) {
        this.imageHashToTypeWithSize = imageHashToTypeWithSize;
        this.unmodifiedModels = unmodifiedModels;
    }

    @Override
    public ValidationResult<ModelChanges<BannerWithImage>, Defect> apply(ModelChanges<BannerWithImage> changes) {
        ModelChangesValidationBuilder<BannerWithImage> vb = ModelChangesValidationBuilder.of(changes);

        vb.check(imageSizeIsNotChanged(unmodifiedModels, imageHashToTypeWithSize),
                When.valueIs(mc -> changes.isPropChanged(BannerWithImage.IMAGE_HASH)));

        return vb.getResult();
    }
}
