package ru.yandex.direct.core.entity.banner.type.image;

import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.ImageSize;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.type.bannerimage.BannerWithBannerImageConstraints.isBannerImageSizeValid;

@ParametersAreNonnullByDefault
public class NewImageSizeValidator implements Validator<String, Defect> {

    private final Map<String, ImageSize> imageHashToSize;
    private final Set<ImageSize> allowedImageSizes;

    public NewImageSizeValidator(Map<String, ImageSize> imageHashToSize, Set<ImageSize> allowedImageSizes) {
        this.imageHashToSize = imageHashToSize;
        this.allowedImageSizes = allowedImageSizes;
    }

    @Override
    public ValidationResult<String, Defect> apply(@Nullable String imageHash) {
        ItemValidationBuilder<String, Defect> vb = ModelItemValidationBuilder.of(imageHash);
        if (imageHash == null) {
            return vb.getResult();
        }

        ImageSize imageSize = imageHashToSize.get(imageHash);
        if (imageSize == null) {
            return vb.getResult();
        }

        vb.check(isBannerImageSizeValid(imageSize, allowedImageSizes), When.isValid());

        return vb.getResult();
    }
}
