package ru.yandex.direct.core.entity.banner.type.image.moderarion;

import java.util.List;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithImageModeration;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerWithChildrenModerationProvider;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
public class BannerWithImageModerationUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithImageModeration> {

    private final BannerWithChildrenModerationProvider<BannerWithImageModeration> provider;

    @Autowired
    public BannerWithImageModerationUpdateOperationTypeSupport(
            List<BannerWithImageModerationProcessor> processors) {

        this.provider = new BannerWithChildrenModerationProvider<>(
                DefaultBannerWithImageModerationProcessor.class,
                processors);
    }

    @Override
    public Class<BannerWithImageModeration> getTypeClass() {
        return BannerWithImageModeration.class;
    }

    @Override
    public void beforeExecutionInTransaction(
            DSLContext dsl,
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannersUpdateOperationContainer updateContainer,
            List<AppliedChanges<BannerWithImageModeration>> appliedChanges) {
        provider.process(dsl, additionalActionsContainer, updateContainer, appliedChanges);
    }
}
