package ru.yandex.direct.core.entity.banner.type.internal;

import java.util.List;
import java.util.Objects;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithInternalInfo;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;
import ru.yandex.direct.core.entity.internalads.model.InternalTemplateInfo;
import ru.yandex.direct.core.entity.internalads.service.InternalAdUrlMacrosService;
import ru.yandex.direct.core.entity.internalads.service.TemplateInfoService;

import static ru.yandex.direct.utils.FunctionalUtils.listToMap;
import static ru.yandex.direct.utils.FunctionalUtils.mapAndFilterToSet;

@Component
public class BannerWithInternalInfoAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithInternalInfo> {

    private final TemplateInfoService templateInfoService;

    @Autowired
    public BannerWithInternalInfoAddOperationTypeSupport(TemplateInfoService templateInfoService) {
        this.templateInfoService = templateInfoService;
    }

    @Override
    public Class<BannerWithInternalInfo> getTypeClass() {
        return BannerWithInternalInfo.class;
    }

    @Override
    public void onPreValidated(BannersAddOperationContainer addContainer, List<BannerWithInternalInfo> models) {
        models.forEach(banner -> {
            banner.setIsStoppedByUrlMonitoring(false);

            if (addContainer.isCopy() && banner.getModerationInfo() != null) {
                // при копировании создаем модерируемые баннеры в черновике
                banner.getModerationInfo().setSendToModeration(false);
            }
        });
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer addContainer, List<BannerWithInternalInfo> models) {
        var templateIds = mapAndFilterToSet(
                models, BannerWithInternalInfo::getTemplateId, Objects::nonNull);

        var internalTemplateInfoList = templateInfoService.getByTemplateIds(templateIds);
        var templateIdToTemplateInfo = listToMap(internalTemplateInfoList, InternalTemplateInfo::getTemplateId);

        models.forEach(banner -> InternalAdUrlMacrosService
                .enrichDefaultUrlParametrsForBanner(banner, templateIdToTemplateInfo));

        var bannersWithUnreachableUrlIndexes = addContainer.getBannersWithUnreachableUrlIndexes();
        if (addContainer.isCopy() && bannersWithUnreachableUrlIndexes != null) {
            for (int index : bannersWithUnreachableUrlIndexes) {
                BannerWithInternalInfo banner = models.get(index);
                banner.setStatusShow(false);
                banner.setIsStoppedByUrlMonitoring(true);
            }
        }
    }
}
