package ru.yandex.direct.core.entity.banner.type.internal;

import java.util.List;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithInternalInfo;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdStringDefectIds;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;
import ru.yandex.direct.validation.result.PathNode;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithInternalInfoAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithInternalInfo> {

    private final BannerWithInternalInfoValidatorProvider validatorProvider;

    @Autowired
    public BannerWithInternalInfoAddValidationTypeSupport(
            BannerWithInternalInfoValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithInternalInfo> getTypeClass() {
        return BannerWithInternalInfo.class;
    }

    @Override
    public ValidationResult<List<BannerWithInternalInfo>, Defect> validate(
            BannersAddOperationContainer container, ValidationResult<List<BannerWithInternalInfo>, Defect> vr) {
        var result = new ListValidationBuilder<>(vr)
                .checkBy(validatorProvider.bannerWithInternalExtraInfoListValidator(container))
                .getResult();
        if (result.hasAnyWarnings()) {
            addBannerWithUnreachableUrlIndexesFromWarningsIntoContainer(container, result.flattenWarnings());
        }
        return result;
    }

    private void addBannerWithUnreachableUrlIndexesFromWarningsIntoContainer(
            BannersAddOperationContainer container, List<DefectInfo<Defect>> warnings) {
        var indexes = StreamEx.of(warnings)
                .filter(defectInfo -> defectInfo.getDefect().defectId() == InternalAdStringDefectIds.URL_UNREACHABLE)
                .map(defectInfo -> ((PathNode.Index) defectInfo.getPath().getNodes().get(0)).getIndex())
                .toSet();
        container.setBannersWithUnreachableUrlIndexes(indexes);
    }
}
