package ru.yandex.direct.core.entity.banner.type.internal;

import java.util.Set;

import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.internalTemplateNotAllowed;
import static ru.yandex.direct.core.entity.internalads.Constants.isModeratedTemplate;

class BannerWithInternalInfoConstraints {

    private BannerWithInternalInfoConstraints() {
    }

    static Constraint<Long, Defect> templateIdAllowed(Set<Long> allowedTemplateIds) {
        return Constraint.fromPredicate(allowedTemplateIds::contains, internalTemplateNotAllowed());
    }

    /**
     * проверяет, что модерируемый шаблон находится в модерируемом плейсе
     * или наоборот - немодерируемый шаблон находится в немодерируемом плейсе
     */
    static Constraint<Long, Defect> templateIdModeratedCorrespondToPlaceId(boolean isModeratedPlace) {
        return Constraint.fromPredicate(templateId -> isModeratedTemplate(templateId) == isModeratedPlace,
                internalTemplateNotAllowed());
    }

}
