package ru.yandex.direct.core.entity.banner.type.internal;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithInternalInfo;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelChangesValidationBuilder;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.forbiddenToChange;
import static ru.yandex.direct.core.validation.ValidationUtils.addErrorIfPropertyChanged;

@Component
public class BannerWithInternalInfoUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithInternalInfo> {

    private final BannerWithInternalInfoValidatorProvider validatorProvider;

    @Autowired
    public BannerWithInternalInfoUpdateValidationTypeSupport(
            BannerWithInternalInfoValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithInternalInfo> getTypeClass() {
        return BannerWithInternalInfo.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<BannerWithInternalInfo>>, Defect> preValidate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<ModelChanges<BannerWithInternalInfo>>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(mc -> {
                    var vb = ModelChangesValidationBuilder.of(mc);
                    addErrorIfPropertyChanged(mc, vb, BannerWithInternalInfo.TEMPLATE_ID, forbiddenToChange());
                    return vb.getResult();
                })
                .getResult();
    }

    @Override
    public ValidationResult<List<BannerWithInternalInfo>, Defect> validate(
            BannersUpdateOperationContainer container, ValidationResult<List<BannerWithInternalInfo>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkBy(validatorProvider.bannerWithInternalExtraInfoListValidator(container))
                .getResult();
    }
}
