package ru.yandex.direct.core.entity.banner.type.internal;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.internal.BannerWithInternalInfoConstants.DESCRIPTION_MAX_LENGTH;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;
import static ru.yandex.direct.validation.constraint.StringConstraints.onlyUtf8Mb3Symbols;

public class DescriptionValidator implements Validator<String, Defect> {

    static DescriptionValidator descriptionValidator() {
        return new DescriptionValidator();
    }

    @Override
    public ValidationResult<String, Defect> apply(String description) {
        ItemValidationBuilder<String, Defect> builder = ItemValidationBuilder.of(description);
        builder
                .check(notNull())
                .check(notBlank())
                .check(onlyUtf8Mb3Symbols(), When.isValid())
                .check(maxStringLength(DESCRIPTION_MAX_LENGTH), When.isValid());

        return builder.getResult();
    }
}
