package ru.yandex.direct.core.entity.banner.type.internal;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.adgroup.model.InternalAdGroup;
import ru.yandex.direct.core.entity.banner.model.BannerWithInternalInfo;
import ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects;
import ru.yandex.direct.core.entity.campaign.model.InternalCampaign;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class InternalMaxStopsCountValidator implements Validator<BannerWithInternalInfo, Defect> {
    private final boolean campaignHasMaxStopsCount;
    private final boolean adGroupHasMaxStopsCount;

    InternalMaxStopsCountValidator(@Nullable InternalCampaign campaign, @Nullable InternalAdGroup adGroup) {
        this.campaignHasMaxStopsCount = ifNotNull(campaign, InternalCampaign::getMaxStopsCount) != null;
        this.adGroupHasMaxStopsCount = ifNotNull(adGroup, InternalAdGroup::getMaxStopsCount) != null;
    }

    @Override
    public ValidationResult<BannerWithInternalInfo, Defect> apply(BannerWithInternalInfo internalBanner) {
        ItemValidationBuilder<BannerWithInternalInfo, Defect> vb = ItemValidationBuilder.of(internalBanner);
        vb.check(this::campaignOrAdGroupMaxStopsCountPresentIfNeeded);
        return vb.getResult();
    }

    private Defect campaignOrAdGroupMaxStopsCountPresentIfNeeded(BannerWithInternalInfo banner) {
        boolean maxStopsCountRequired =
                BannerWithInternalInfoConstants.MAX_STOPS_COUNT_REQUIRED_TEMPLATE_IDS.contains(banner.getTemplateId());
        if (maxStopsCountRequired && !campaignHasMaxStopsCount && !adGroupHasMaxStopsCount) {
            return BannerDefects.requiredCampaignOrAdGroupMaxStopsCountButEmpty();
        }
        return null;
    }
}
