package ru.yandex.direct.core.entity.banner.type.internal;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.InternalModerationInfo;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.model.InternalModerationInfo.IS_SECRET_AD;
import static ru.yandex.direct.core.entity.banner.model.InternalModerationInfo.SEND_TO_MODERATION;
import static ru.yandex.direct.core.entity.banner.model.InternalModerationInfo.STATUS_SHOW_AFTER_MODERATION;
import static ru.yandex.direct.core.entity.banner.model.InternalModerationInfo.TICKET_URL;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.startWith;

/**
 * Валидирует поля модели {@link InternalModerationInfo}
 */
@ParametersAreNonnullByDefault
public class InternalModerationInfoValidator implements Validator<InternalModerationInfo, Defect> {

    private static final String URL_PREFIX = "https://st.yandex-team.ru/";

    @Override
    public ValidationResult<InternalModerationInfo, Defect> apply(InternalModerationInfo moderationInfo) {
        ModelItemValidationBuilder<InternalModerationInfo> ivb = ModelItemValidationBuilder.of(moderationInfo);

        ivb.item(TICKET_URL)
                .check(notNull())
                .check(startWith(URL_PREFIX), When.isValid());

        ivb.item(IS_SECRET_AD)
                .check(notNull());

        ivb.item(STATUS_SHOW_AFTER_MODERATION)
                .check(notNull());

        ivb.item(SEND_TO_MODERATION)
                .check(notNull());

        return ivb.getResult();
    }
}
