package ru.yandex.direct.core.entity.banner.type.internal;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.banner.model.BannerWithInternalInfo;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.TemplateVariable;
import ru.yandex.direct.core.entity.banner.type.href.BannerUrlCheckService;
import ru.yandex.direct.core.entity.internalads.model.InternalTemplateInfo;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

/**
 * Валидатор, проверяющий {@link TemplateVariable}, при включении баннеров.
 * Валидация происходит для {@link ModelChanges<BannerWithSystemFields>}, которые не используются, так как
 * в рамках включения {@link TemplateVariable} не меняется.
 */
class ResumeTemplateVariablesValidator extends AbstractTemplateVariablesValidator<ModelChanges<BannerWithSystemFields>> {

    ResumeTemplateVariablesValidator(BannerWithInternalInfo banner,
                                     InternalTemplateInfo internalTemplateInfo,
                                     BannerUrlCheckService bannerUrlCheckService) {
        super(banner, internalTemplateInfo, bannerUrlCheckService);
    }

    @Override
    public ValidationResult<ModelChanges<BannerWithSystemFields>, Defect> apply(
            ModelChanges<BannerWithSystemFields> modelChanges) {

        var templateVariables = banner.getTemplateVariables();

        ItemValidationBuilder<ModelChanges<BannerWithSystemFields>, Defect> vb =
                ItemValidationBuilder.of(modelChanges);

        vb.check(checkTemplateVariables(templateVariables));

        return vb.getResult();
    }

    private Constraint<ModelChanges<BannerWithSystemFields>, Defect> checkTemplateVariables(
            List<TemplateVariable> templateVariables) {

        var defect = StreamEx.of(templateVariables)
                .mapToEntry(this::variableValueUrlIsReachable)
                .nonNullValues()
                .findFirst()
                .map(Map.Entry::getValue)
                .orElse(null);

        return mc -> defect;
    }
}
