package ru.yandex.direct.core.entity.banner.type.internal;

import java.util.Set;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.internal.BannerWithInternalInfoConstraints.templateIdAllowed;
import static ru.yandex.direct.core.entity.banner.type.internal.BannerWithInternalInfoConstraints.templateIdModeratedCorrespondToPlaceId;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;

public class TemplateIdValidator implements Validator<Long, Defect> {

    private final Set<Long> allowedTemplateIds;
    private final boolean isModeratedPlace;

    public static TemplateIdValidator templateIdValidator(Set<Long> allowedTemplateIds, boolean isModeratedPlace) {
        return new TemplateIdValidator(allowedTemplateIds, isModeratedPlace);
    }

    private TemplateIdValidator(Set<Long> allowedTemplateIds, boolean isModeratedPlace) {
        this.allowedTemplateIds = allowedTemplateIds;
        this.isModeratedPlace = isModeratedPlace;
    }

    @Override
    public ValidationResult<Long, Defect> apply(Long templateId) {
        return ItemValidationBuilder.<Long, Defect>of(templateId)
                .check(notNull())
                .check(validId())
                .check(templateIdAllowed(allowedTemplateIds), When.isValid())
                .check(templateIdModeratedCorrespondToPlaceId(isModeratedPlace), When.isValid())
                .getResult();
    }

}
