package ru.yandex.direct.core.entity.banner.type.ismobile;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithIsMobile;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerDefaultRepositoryTypeSupport;
import ru.yandex.direct.core.entity.banner.repository.type.ModifiedPaths;
import ru.yandex.direct.dbschema.ppc.enums.BannersType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.grut.objects.proto.client.Schema;

import static java.util.Collections.emptySet;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

@Component
public class BannerWithIsMobileRepositoryTypeSupport extends
        AbstractBannerDefaultRepositoryTypeSupport<BannerWithIsMobile> {

    @Autowired
    public BannerWithIsMobileRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BannerWithIsMobile.IS_MOBILE, BANNERS.TYPE,
                BannerWithIsMobileRepositoryTypeSupport::isMobileFromDb,
                BannerWithIsMobileRepositoryTypeSupport::isMobileToDb);
    }

    @Override
    public Class<BannerWithIsMobile> getTypeClass() {
        return BannerWithIsMobile.class;
    }

    private static BannersType isMobileToDb(Boolean isMobile) {
        return isMobile == null || !isMobile ? BannersType.desktop : BannersType.mobile;
    }

    private static Boolean isMobileFromDb(BannersType value) {
        return value != null ? value == BannersType.mobile : null;
    }

    @Override
    public Set<ModelProperty<? super BannerWithIsMobile, ?>> getGrutSupportedProperties() {
        return Set.of(BannerWithIsMobile.IS_MOBILE);
    }

    @Override
    public Map<Long, ModifiedPaths> applyToGrutObjects(
            @NotNull Map<Long, Schema.TBannerV2.Builder> bannerBuilders,
            @NotNull Collection<AppliedChanges<BannerWithIsMobile>> appliedChangesList,
            @NotNull BannersOperationContainer operationContainer) {
        Map<Long, ModifiedPaths> modifiedPathsMap = new HashMap<>();
        for (AppliedChanges<BannerWithIsMobile> appliedChanges : appliedChangesList) {
            if (appliedChanges.getPropertiesForUpdate().contains(BannerWithIsMobile.IS_MOBILE)) {
                Long id = appliedChanges.getModel().getId();
                Schema.TBannerV2.Builder bannerBuilder = bannerBuilders.get(id);
                ModifiedPaths modifiedPaths;
                Boolean newValue = appliedChanges.getNewValue(BannerWithIsMobile.IS_MOBILE);
                if (newValue != null) {
                    bannerBuilder.getSpecBuilder().setIsMobile(newValue);
                    modifiedPaths = new ModifiedPaths(Set.of("/spec/is_mobile"), emptySet());
                } else {
                    modifiedPaths = new ModifiedPaths(emptySet(), Set.of("/spec/is_mobile"));
                }
                modifiedPathsMap.put(id, modifiedPaths);
            }
        }
        return modifiedPathsMap;
    }
}
