package ru.yandex.direct.core.entity.banner.type.language;

import ru.yandex.direct.core.entity.banner.model.Language;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class BannerLanguageConverter {

    private static Logger logger = LoggerFactory.getLogger(BannerLanguageConverter.class);

    /**
     * Конвертирует язык баннера из строкового представления в ядровое.
     *
     * @param language  язык баннера в строковом представлении
     * @return язык баннера в ядровом представлении
     */
    public static Language convertLanguage(String language) {
        if (language == null) {
            return Language.UNKNOWN;
        }

        try {
            return "ru".equals(language) ? Language.RU_ : Language.valueOf(language.toUpperCase());
        } catch (Exception e) {
            logger.error("Unknown language value: {}", language);
            return Language.UNKNOWN;
        }
    }

    /**
     * Конвертирует язык баннера из queryrec представления в ядровое.
     *
     * @param language  язык баннера в queryrec представлении
     * @return язык баннера в ядровом представлении
     */
    public static Language convertLanguage(ru.yandex.direct.queryrec.model.Language language) {
        if (language == null) {
            return Language.UNKNOWN;
        }

        switch (language) {
            case KAZAKH:
                return Language.KK;
            case TURKISH:
                return Language.TR;
            case UKRAINIAN:
                return Language.UK;
            case GERMAN:
                return Language.DE;
            case ENGLISH:
                return Language.EN;
            case RUSSIAN:
                return Language.RU_;
            case BELARUSIAN:
                return Language.BE;
            case UZBEK:
                return Language.UZ;
            case VIE:
                return Language.VIE;
            case SPANISH:
                return Language.ES;
            case PORTUGUESE:
                return Language.PT;
            case CZECH:
                return Language.CS;
            case POLISH:
                return Language.PL;
            case UNKNOWN:
                return Language.UNKNOWN;
            default:
                logger.error("Unknown language value: {}", language);
                return Language.UNKNOWN;
        }
    }

    /**
     * Конвертирует язык баннера из ядрового представления в queryrec.
     *
     * @param language  язык баннера в ядровом представлении
     * @return язык баннера в queryrec представлении
     */
    public static ru.yandex.direct.queryrec.model.Language convertLanguage(Language language) {
        if (language == null) {
            return ru.yandex.direct.queryrec.model.Language.UNKNOWN;
        }

        switch (language) {
            case KK:
                return ru.yandex.direct.queryrec.model.Language.KAZAKH;
            case TR:
                return ru.yandex.direct.queryrec.model.Language.TURKISH;
            case UK:
                return ru.yandex.direct.queryrec.model.Language.UKRAINIAN;
            case DE:
                return ru.yandex.direct.queryrec.model.Language.GERMAN;
            case EN:
                return ru.yandex.direct.queryrec.model.Language.ENGLISH;
            case RU_:
                return ru.yandex.direct.queryrec.model.Language.RUSSIAN;
            case BE:
                return ru.yandex.direct.queryrec.model.Language.BELARUSIAN;
            case UZ:
                return ru.yandex.direct.queryrec.model.Language.UZBEK;
            case VIE:
                return ru.yandex.direct.queryrec.model.Language.VIE;
            case ES:
                return ru.yandex.direct.queryrec.model.Language.SPANISH;
            case PT:
                return ru.yandex.direct.queryrec.model.Language.PORTUGUESE;
            case CS:
                return ru.yandex.direct.queryrec.model.Language.CZECH;
            case PL:
                return ru.yandex.direct.queryrec.model.Language.POLISH;
            case NO:
            case YES:
            case UNKNOWN:
                return ru.yandex.direct.queryrec.model.Language.UNKNOWN;
            default:
                logger.error("Unknown language value: {}", language);
                return ru.yandex.direct.queryrec.model.Language.UNKNOWN;
        }
    }
}
