package ru.yandex.direct.core.entity.banner.type.language;

import java.util.Collection;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.model.Language;
import ru.yandex.direct.dbschema.ppc.enums.BannersLanguage;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@Repository
public class BannerLanguageRepository {

    private final DslContextProvider dslContextProvider;

    @Autowired
    public BannerLanguageRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Сбрасывает язык на баннерах (не изменяя last change).
     *
     * @param shard шард
     * @param bids  id баннеров
     */
    public void clearBannersLanguage(int shard, Collection<Long> bids) {
        dslContextProvider.ppc(shard)
                .update(BANNERS)
                .set(BANNERS.LANGUAGE, BannersLanguage.unknown)
                .set(BANNERS.LAST_CHANGE, BANNERS.LAST_CHANGE)
                .where(BANNERS.BID.in(bids))
                .execute();
    }

    /**
     * Возвращает мап (bannerId -> language).
     *
     * @param shard шард
     * @param bids  id баннеров
     * @return мап (bannerId -> language)
     */
    public Map<Long, Language> getLanguageByBid(int shard, Collection<Long> bids) {
        return dslContextProvider.ppc(shard)
                .select(BANNERS.BID, BANNERS.LANGUAGE)
                .from(BANNERS)
                .where(BANNERS.BID.in(bids))
                .fetchMap(rec -> rec.get(BANNERS.BID), rec -> Language.fromSource(rec.get(BANNERS.LANGUAGE)));
    }
}
