package ru.yandex.direct.core.entity.banner.type.language;

import java.util.Collections;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.queryrec.QueryrecService;
import ru.yandex.direct.queryrec.model.Language;
import ru.yandex.direct.regions.GeoTreeFactory;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.banner.type.language.BannerLanguageConstraint.newBannerLanguageConstraint;
import static ru.yandex.direct.core.entity.banner.type.language.BannerLanguageConverter.convertLanguage;

/**
 * Проверка соответствия языка баннера и геотаргетинга группы с учетом выставления языка на кампанию.
 */
@Component
@ParametersAreNonnullByDefault
public class BannerLanguageValidator {

    private final QueryrecService queryrecService;
    private final GeoTreeFactory geoTreeFactory;

    private final ru.yandex.direct.core.entity.banner.service.text.BannerTextExtractor newBannerTextExtractor;

    @Autowired
    public BannerLanguageValidator(
            QueryrecService queryrecService, GeoTreeFactory geoTreeFactory,
            ru.yandex.direct.core.entity.banner.service.text.BannerTextExtractor newBannerTextExtractor) {
        this.queryrecService = queryrecService;
        this.geoTreeFactory = geoTreeFactory;
        this.newBannerTextExtractor = newBannerTextExtractor;
    }

    public <T extends BannerWithSystemFields> Constraint<T, Defect> newLanguageIsFromGeo(List<Long> adGroupGeoIds,
                                                                                         Language campaignLanguage,
                                                                                         ClientId clientId,
                                                                                         @Nullable Long clientRegionId) {
        return (banner) -> {
            String text = newBannerTextExtractor.extractTexts(Collections.singletonList(banner)).get(banner);
            Language bannerLanguage = convertLanguage(banner.getLanguage());
            return newBannerLanguageConstraint(queryrecService, geoTreeFactory, campaignLanguage,
                    adGroupGeoIds, bannerLanguage, clientId, clientRegionId).apply(text);
        };
    }
}
