package ru.yandex.direct.core.entity.banner.type.language;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithLanguage;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;

@Component
public class BannerWithLanguageAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithLanguage> {

    private final BannerWithLanguageFiller languageFiller;

    @Autowired
    public BannerWithLanguageAddOperationTypeSupport(BannerWithLanguageFiller languageFiller) {
        this.languageFiller = languageFiller;
    }

    @Override
    public Class<BannerWithLanguage> getTypeClass() {
        return BannerWithLanguage.class;
    }

    @Override
    public void onPreValidated(BannersAddOperationContainer addContainer, List<BannerWithLanguage> banners) {
        languageFiller.fillBannersLanguage(addContainer, banners);
    }
}
