package ru.yandex.direct.core.entity.banner.type.language;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithLanguage;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithLanguageAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithLanguage> {

    private final BannerWithLanguageValidatorProvider provider;

    @Autowired
    public BannerWithLanguageAddValidationTypeSupport(BannerWithLanguageValidatorProvider provider) {
        this.provider = provider;
    }

    @Override
    public Class<BannerWithLanguage> getTypeClass() {
        return BannerWithLanguage.class;
    }

    @Override
    public ValidationResult<List<BannerWithLanguage>, Defect> validate(BannersAddOperationContainer container,
                                                                       ValidationResult<List<BannerWithLanguage>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkBy(provider.bannerWithLanguageValidator(container))
                .getResult();
    }
}
