package ru.yandex.direct.core.entity.banner.type.language;

import java.util.IdentityHashMap;
import java.util.List;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithLanguage;
import ru.yandex.direct.core.entity.banner.model.Language;
import ru.yandex.direct.core.entity.banner.service.text.BannerTextExtractor;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.queryrec.QueryrecService;

import static java.util.function.Function.identity;
import static ru.yandex.direct.core.entity.banner.model.BannerWithLanguage.LANGUAGE;
import static ru.yandex.direct.core.entity.banner.type.language.BannerLanguageConverter.convertLanguage;

@Component
class BannerWithLanguageFiller {

    private final QueryrecService queryrecService;
    private final BannerTextExtractor bannerTextExtractor;

    @Autowired
    BannerWithLanguageFiller(QueryrecService queryrecService, BannerTextExtractor bannerTextExtractor) {
        this.queryrecService = queryrecService;
        this.bannerTextExtractor = bannerTextExtractor;
    }

    <T extends BannerWithLanguage> void fillBannersLanguage(
            BannersAddOperationContainer container,
            List<T> banners) {
        EntryStream.of(bannerTextExtractor.extractTexts(banners))
                .mapValues(text -> recognizeLanguage(container, text))
                .forKeyValue(BannerWithLanguage::setLanguage);
    }

    <T extends BannerWithLanguage> void fillBannerChangesLanguage(
            BannersUpdateOperationContainer container,
            List<AppliedChanges<T>> bannerChanges) {
        IdentityHashMap<T, AppliedChanges<T>> bannerToChangesMap =
                StreamEx.of(bannerChanges)
                        .mapToEntry(AppliedChanges::getModel, identity())
                        .toCustomMap(IdentityHashMap::new);

        EntryStream.of(bannerTextExtractor.extractTexts(bannerToChangesMap.keySet()))
                .mapKeys(bannerToChangesMap::get)
                .mapValues(text -> recognizeLanguage(container, text))
                .forKeyValue((ac, language) -> ac.modify(LANGUAGE, language));
    }

    private Language recognizeLanguage(BannersOperationContainer container, String text) {
        return convertLanguage(
                queryrecService.recognize(text, container.getClientId(), container.getClientRegionId()));
    }
}
