package ru.yandex.direct.core.entity.banner.type.language;

import java.util.List;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithLanguage;
import ru.yandex.direct.core.entity.banner.service.BannerTextChangeUtil;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
public class BannerWithLanguageUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithLanguage> {

    private final BannerWithLanguageFiller languageFiller;

    @Autowired
    public BannerWithLanguageUpdateOperationTypeSupport(BannerWithLanguageFiller languageFiller) {
        this.languageFiller = languageFiller;
    }

    @Override
    public Class<BannerWithLanguage> getTypeClass() {
        return BannerWithLanguage.class;
    }


    @Override
    public void onChangesApplied(BannersUpdateOperationContainer container,
                                 List<AppliedChanges<BannerWithLanguage>> appliedChangesList) {
        List<AppliedChanges<BannerWithLanguage>> changesWithChangedText =
                StreamEx.of(appliedChangesList)
                        .filter(BannerTextChangeUtil::isBannerTextChangedSignificantly)
                        .toList();
        languageFiller.fillBannerChangesLanguage(container, changesWithChangedText);
    }
}
