package ru.yandex.direct.core.entity.banner.type.language;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithLanguage;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithLanguageUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithLanguage> {

    private final BannerWithLanguageValidatorProvider provider;

    @Autowired
    public BannerWithLanguageUpdateValidationTypeSupport(BannerWithLanguageValidatorProvider provider) {
        this.provider = provider;
    }

    @Override
    public Class<BannerWithLanguage> getTypeClass() {
        return BannerWithLanguage.class;
    }

    @Override
    public ValidationResult<List<BannerWithLanguage>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithLanguage>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkBy(provider.bannerWithLanguageValidator(container))
                .getResult();
    }
}
