package ru.yandex.direct.core.entity.banner.type.lastchange;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.model.AppliedChanges;

import static java.time.LocalDateTime.now;
import static ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields.LAST_CHANGE;
import static ru.yandex.direct.core.entity.banner.service.BannerUtils.selectAppliedChanges;

@Service
public class BannersUpdateLastChangeResetService {

    public <T extends Banner> void reset(Set<Long> bannerIdsToLastChangeReset,
                                         List<AppliedChanges<T>> bannerChanges) {

        LocalDateTime timeNow = now();

        selectAppliedChanges(bannerChanges, BannerWithSystemFields.class).stream()
                .filter(x -> bannerIdsToLastChangeReset.contains(x.getModel().getId()))
                .forEach(x -> x.modify(LAST_CHANGE, timeNow));
    }
}
