package ru.yandex.direct.core.entity.banner.type.leadformattributes;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithLeadformAttributes;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.leadformattributes.BannerWithLeadformAttributesValidatorProvider.bannerWithLeadformAttributesValidator;

@Component
@ParametersAreNonnullByDefault
public class BannerWithLeadformAttributesAddValidationTypeSupport extends
        AbstractBannerAddValidationTypeSupport<BannerWithLeadformAttributes> {

    @Override
    public Class<BannerWithLeadformAttributes> getTypeClass() {
        return BannerWithLeadformAttributes.class;
    }

    @Override
    public ValidationResult<List<BannerWithLeadformAttributes>, Defect> validate(
            BannersAddOperationContainer container,
            ValidationResult<List<BannerWithLeadformAttributes>, Defect> vr
    ) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(bannerWithLeadformAttributesValidator())
                .getResult();
    }
}
