package ru.yandex.direct.core.entity.banner.type.leadformattributes;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithLeadformAttributes;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractFlatRelatedEntityUpsertRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerLeadformAttributesRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;

import static ru.yandex.direct.dbschema.ppc.tables.BannerLeadformAttributes.BANNER_LEADFORM_ATTRIBUTES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class BannerWithLeadformAttributesRepositoryTypeSupport extends
        AbstractFlatRelatedEntityUpsertRepositoryTypeSupport<BannerWithLeadformAttributes, BannerLeadformAttributesRecord> {

    public static final Set<ModelProperty<? super BannerWithLeadformAttributes, ?>> LEADFORM_ATTRIBUTES_PROPERTIES
            = Set.of(BannerWithLeadformAttributes.LEADFORM_HREF, BannerWithLeadformAttributes.LEADFORM_BUTTON_TEXT);

    @Autowired
    public BannerWithLeadformAttributesRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BANNER_LEADFORM_ATTRIBUTES.BID, createMapper());
    }

    private static JooqMapper<BannerWithLeadformAttributes> createMapper() {
        return JooqMapperBuilder.<BannerWithLeadformAttributes>builder()
                .map(property(BannerWithLeadformAttributes.LEADFORM_HREF,
                        BANNER_LEADFORM_ATTRIBUTES.LEADFORM_HREF))
                .map(property(BannerWithLeadformAttributes.LEADFORM_BUTTON_TEXT,
                        BANNER_LEADFORM_ATTRIBUTES.LEADFORM_BUTTON_TEXT))
                .writeField(BANNER_LEADFORM_ATTRIBUTES.BID, fromProperty(BannerWithLeadformAttributes.ID))
                .build();
    }

    @Override
    protected void upsertEntity(DSLContext context, Collection<BannerWithLeadformAttributes> banners) {
        var helper = new InsertHelper<>(context, BANNER_LEADFORM_ATTRIBUTES);
        helper.addAll(getJooqMapper(), banners);

        helper.onDuplicateKeyUpdate()
                .set(BANNER_LEADFORM_ATTRIBUTES.LEADFORM_HREF,
                        MySQLDSL.values(BANNER_LEADFORM_ATTRIBUTES.LEADFORM_HREF))
                .set(BANNER_LEADFORM_ATTRIBUTES.LEADFORM_BUTTON_TEXT,
                        MySQLDSL.values(BANNER_LEADFORM_ATTRIBUTES.LEADFORM_BUTTON_TEXT));

        helper.executeIfRecordsAdded();
    }

    @Override
    protected boolean isAddEntity(BannerWithLeadformAttributes banner) {
        return banner.getLeadformHref() != null || banner.getLeadformButtonText() != null;
    }

    @Override
    protected boolean isUpsertEntity(AppliedChanges<BannerWithLeadformAttributes> appliedChange) {
        return LEADFORM_ATTRIBUTES_PROPERTIES.stream().anyMatch(prop -> appliedChange.getNewValue(prop) != null)
                && LEADFORM_ATTRIBUTES_PROPERTIES.stream().anyMatch(appliedChange::changed);
    }

    @Override
    protected boolean isDeleteEntity(AppliedChanges<BannerWithLeadformAttributes> appliedChange) {
        return LEADFORM_ATTRIBUTES_PROPERTIES.stream().allMatch(prop -> appliedChange.getNewValue(prop) == null)
                && LEADFORM_ATTRIBUTES_PROPERTIES.stream().anyMatch(appliedChange::changed);
    }

    @Override
    public Class<BannerWithLeadformAttributes> getTypeClass() {
        return BannerWithLeadformAttributes.class;
    }
}
