package ru.yandex.direct.core.entity.banner.type.leadformattributes;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithLeadformAttributes;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.type.leadformattributes.BannerWithLeadformAttributesRepositoryTypeSupport.LEADFORM_ATTRIBUTES_PROPERTIES;

@Component
@ParametersAreNonnullByDefault
public class BannerWithLeadformAttributesUpdateOperationTypeSupport extends
        AbstractBannerUpdateOperationTypeSupport<BannerWithLeadformAttributes> {

    @Override
    public Class<BannerWithLeadformAttributes> getTypeClass() {
        return BannerWithLeadformAttributes.class;
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithLeadformAttributes> appliedChanges) {
        return LEADFORM_ATTRIBUTES_PROPERTIES.stream().anyMatch(appliedChanges::changed);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithLeadformAttributes> appliedChanges) {
        return LEADFORM_ATTRIBUTES_PROPERTIES.stream().anyMatch(appliedChanges::changed);
    }
}
