package ru.yandex.direct.core.entity.banner.type.leadformattributes;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithLeadformAttributes;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.leadformattributes.BannerWithLeadformAttributesValidatorProvider.bannerWithLeadformAttributesValidator;

@Component
@ParametersAreNonnullByDefault
public class BannerWithLeadformAttributesUpdateValidationTypeSupport extends
        AbstractBannerUpdateValidationTypeSupport<BannerWithLeadformAttributes> {

    @Override
    public ValidationResult<List<BannerWithLeadformAttributes>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithLeadformAttributes>, Defect> vr
    ) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(bannerWithLeadformAttributesValidator())
                .getResult();
    }

    @Override
    public Class<BannerWithLeadformAttributes> getTypeClass() {
        return BannerWithLeadformAttributes.class;
    }
}
