package ru.yandex.direct.core.entity.banner.type.logos;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerLogoStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithLogo;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;

import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.isEffectiveSaveDraft;

@Component
public class BannerWithLogoAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithLogo> {

    @Override
    public Class<BannerWithLogo> getTypeClass() {
        return BannerWithLogo.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer addContainer, List<BannerWithLogo> models) {
        models.forEach(banner -> fillSystemFields(addContainer, banner));
    }

    private void fillSystemFields(BannersAddOperationContainer addContainer, BannerWithLogo banner) {
        var effectiveSaveDraft = isEffectiveSaveDraft(addContainer, banner);

        if (banner.getLogoImageHash() != null) {
            banner.withLogoStatusModerate(effectiveSaveDraft ?
                    BannerLogoStatusModerate.NEW : BannerLogoStatusModerate.READY);
        }
    }
}
