package ru.yandex.direct.core.entity.banner.type.logos;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerRepositoryContainer;
import ru.yandex.direct.core.entity.banner.model.BannerLogoStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithLogo;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractFlatRelatedEntityRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerLogosRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_LOGOS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class BannerWithLogoRepositoryTypeSupport
        extends AbstractFlatRelatedEntityRepositoryTypeSupport
        <BannerWithLogo, BannerLogosRecord> {

    @Autowired
    public BannerWithLogoRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BANNER_LOGOS.BID, createMapper());
    }

    @Override
    protected void addEntities(DSLContext context,
                               BannerRepositoryContainer updateParameters,
                               Collection<BannerWithLogo> entities) {
        InsertHelper<BannerLogosRecord> insertHelper = new InsertHelper<>(context, BANNER_LOGOS)
                .addAll(getJooqMapper(), entities);
        insertHelper.executeIfRecordsAdded();
    }

    @Override
    protected boolean isAddEntity(BannerWithLogo model) {
        return model.getLogoImageHash() != null;
    }

    @Override
    protected boolean isAddEntity(AppliedChanges<BannerWithLogo> appliedChange) {
        return appliedChange.assigned(BannerWithLogo.LOGO_IMAGE_HASH);
    }

    @Override
    protected boolean isUpdateEntity(AppliedChanges<BannerWithLogo> appliedChange) {
        return appliedChange.replaced(BannerWithLogo.LOGO_IMAGE_HASH) ||
                appliedChange.replaced(BannerWithLogo.LOGO_STATUS_MODERATE);
    }

    @Override
    protected boolean isDeleteEntity(AppliedChanges<BannerWithLogo> appliedChange) {
        return appliedChange.deleted(BannerWithLogo.LOGO_IMAGE_HASH);
    }

    @Override
    public Class<BannerWithLogo> getTypeClass() {
        return BannerWithLogo.class;
    }

    private static JooqMapper<BannerWithLogo> createMapper() {
        return JooqMapperBuilder.<BannerWithLogo>builder()
                .map(property(BannerWithLogo.LOGO_IMAGE_HASH, BANNER_LOGOS.IMAGE_HASH))
                .map(convertibleProperty(BannerWithLogo.LOGO_STATUS_MODERATE,
                        BANNER_LOGOS.STATUS_MODERATE,
                        BannerLogoStatusModerate::fromSource,
                        BannerLogoStatusModerate::toSource))
                .writeField(BANNER_LOGOS.BID, fromProperty(BannerWithLogo.ID))
                .build();
    }
}
