package ru.yandex.direct.core.entity.banner.type.logos;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithLogo;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class BannerWithLogoUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithLogo> {

    @Override
    public Class<BannerWithLogo> getTypeClass() {
        return BannerWithLogo.class;
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithLogo> appliedChanges) {
        return appliedChanges.changed(BannerWithLogo.LOGO_IMAGE_HASH);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithLogo> appliedChanges) {
        return appliedChanges.changed(BannerWithLogo.LOGO_IMAGE_HASH);
    }
}
