package ru.yandex.direct.core.entity.banner.type.logos;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithLogo;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithLogoUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithLogo> {
    private final BannerWithLogoValidatorProvider validatorProvider;

    @Autowired
    public BannerWithLogoUpdateValidationTypeSupport(BannerWithLogoValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithLogo> getTypeClass() {
        return BannerWithLogo.class;
    }

    @Override
    public ValidationResult<List<BannerWithLogo>, Defect> validate(
            BannersUpdateOperationContainer container, ValidationResult<List<BannerWithLogo>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithLogoValidator(container, vr.getValue()))
                .getResult();
    }
}
