package ru.yandex.direct.core.entity.banner.type.logos.moderation;

import java.util.List;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerLogoStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithLogoModeration;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithLogoModeration.LOGO_STATUS_MODERATE;
import static ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses.STATUS_MODERATE;
import static ru.yandex.direct.core.entity.banner.model.CpmBanner.LOGO_IMAGE_HASH;
import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.bannerBecameDraft;

@Component
public class DefaultBannerWithLogoModerationProcessor implements BannerWithLogoModerationProcessor {
    @Override
    public Class<BannerWithLogoModeration> getProcessedClass() {
        return BannerWithLogoModeration.class;
    }

    @Override
    public void process(
            DSLContext dsl,
            BannerAdditionalActionsContainer additionalActionsContainer, BannersUpdateOperationContainer container,
            List<AppliedChanges<BannerWithLogoModeration>> appliedChanges) {

        for (AppliedChanges<BannerWithLogoModeration> changes : appliedChanges) {
            if (!changes.hasActuallyChangedProps() && container.getModerationMode().isDefault()) {
                continue;
            }

            if (changes.getNewValue(LOGO_IMAGE_HASH) == null) {
                continue;
            }

            if (bannerBecameDraft(changes)) {
                changes.modify(LOGO_STATUS_MODERATE, BannerLogoStatusModerate.NEW);
                continue;
            }

            if (changes.getNewValue(STATUS_MODERATE) == BannerStatusModerate.READY ||
                    changes.changed(LOGO_IMAGE_HASH)) {
                    changes.modify(LOGO_STATUS_MODERATE, BannerLogoStatusModerate.READY);
            }
        }
    }
}
