package ru.yandex.direct.core.entity.banner.type.logos.moderation;

import java.util.List;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithLogoModeration;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerWithChildrenModerationProvider;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
public class DefaultBannerWithLogoModerationUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithLogoModeration> {

    private final BannerWithChildrenModerationProvider<BannerWithLogoModeration> provider;

    @Autowired
    public DefaultBannerWithLogoModerationUpdateOperationTypeSupport(
            List<BannerWithLogoModerationProcessor> processors) {

        this.provider = new BannerWithChildrenModerationProvider<>(
                DefaultBannerWithLogoModerationProcessor.class,
                processors);
    }

    @Override
    public Class<BannerWithLogoModeration> getTypeClass() {
        return BannerWithLogoModeration.class;
    }

    @Override
    public void beforeExecutionInTransaction(
            DSLContext dsl,
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannersUpdateOperationContainer updateContainer,
            List<AppliedChanges<BannerWithLogoModeration>> appliedChanges) {
        provider.process(dsl, additionalActionsContainer, updateContainer, appliedChanges);
    }
}
