package ru.yandex.direct.core.entity.banner.type.measurers;

import ru.yandex.direct.core.entity.banner.model.BannerWithMeasurers;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.type.measurers.BannerMeasurersConstraints.bannerMeasurerNotNull;
import static ru.yandex.direct.core.entity.banner.type.measurers.BannerMeasurersConstraints.validBannerMeasurerParams;
import static ru.yandex.direct.core.entity.banner.type.measurers.BannerMeasurersConstraints.validateDuplicateMeasurerSystems;

public class BannerMeasurersValidator implements Validator<BannerWithMeasurers, Defect> {
    @Override
    public ValidationResult<BannerWithMeasurers, Defect> apply(BannerWithMeasurers banner) {
        ModelItemValidationBuilder<BannerWithMeasurers> vb = ModelItemValidationBuilder.of(banner);
        vb.list(banner.getMeasurers(), BannerWithMeasurers.MEASURERS.name())
                .checkEach(bannerMeasurerNotNull())
                .checkEach(validBannerMeasurerParams(), When.isValid())
                .check(validateDuplicateMeasurerSystems());
        return vb.getResult();
    }
}
