package ru.yandex.direct.core.entity.banner.type.measurers;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerMeasurer;
import ru.yandex.direct.core.entity.banner.model.BannerWithMeasurers;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;
import ru.yandex.direct.feature.FeatureName;

@Component
public class BannerWithMeasurersAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithMeasurers> {

    @Override
    public Class<BannerWithMeasurers> getTypeClass() {
        return BannerWithMeasurers.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer addContainer, List<BannerWithMeasurers> models) {
        models.forEach(banner -> fillSystemFields(addContainer, banner));
    }

    private void fillSystemFields(BannersAddOperationContainer addContainer, BannerWithMeasurers banner) {
        if (addContainer.getClientEnabledFeatures().contains(FeatureName.MOAT_USE_UNSTABLE_SCRIPT.getName())) {
            List<BannerMeasurer> measurers = banner.getMeasurers();
            BannerWithMeasurersUtils.setMoatUseUnstableScript(measurers);
        }
    }
}
