package ru.yandex.direct.core.entity.banner.type.measurers;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithMeasurers;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithMeasurersAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithMeasurers> {
    private final BannerWithMeasurersValidatorProvider validatorProvider;

    @Autowired
    public BannerWithMeasurersAddValidationTypeSupport(BannerWithMeasurersValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithMeasurers> getTypeClass() {
        return BannerWithMeasurers.class;
    }

    @Override
    public ValidationResult<List<BannerWithMeasurers>, Defect> validate(
            BannersAddOperationContainer container, ValidationResult<List<BannerWithMeasurers>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithMeasurersValidator())
                .checkEachBy(validatorProvider.bannerWithMeasurersMediascopeAuthValidator(container.getClientId().asLong()))
                .getResult();
    }
}
