package ru.yandex.direct.core.entity.banner.type.measurers;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerMeasurer;
import ru.yandex.direct.core.entity.banner.model.BannerWithMeasurers;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.type.measurers.BannerWithMeasurersUtils.isBannerMeasurersChanged;

@Component
@ParametersAreNonnullByDefault
public class BannerWithMeasurersUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithMeasurers> {

    @Override
    public Class<BannerWithMeasurers> getTypeClass() {
        return BannerWithMeasurers.class;
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithMeasurers> appliedChanges) {
        return isBannerMeasurersChanged(appliedChanges);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithMeasurers> appliedChanges) {
        return isBannerMeasurersChanged(appliedChanges);
    }

    @Override
    public void beforeExecution(BannersUpdateOperationContainer updateContainer,
                                List<AppliedChanges<BannerWithMeasurers>> appliedChanges) {
        if (updateContainer.getClientEnabledFeatures().contains(FeatureName.MOAT_USE_UNSTABLE_SCRIPT.getName())) {
            for (AppliedChanges<BannerWithMeasurers> changes : appliedChanges) {
                List<BannerMeasurer> measurers = changes.getModel().getMeasurers();
                BannerWithMeasurersUtils.setMoatUseUnstableScript(measurers);
                changes.modify(BannerWithMeasurers.MEASURERS, measurers);
            }
        }
    }
}
