package ru.yandex.direct.core.entity.banner.type.measurers;

import java.util.List;
import java.util.Objects;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.BannerMeasurer;
import ru.yandex.direct.core.entity.banner.model.BannerMeasurerSystem;
import ru.yandex.direct.core.entity.banner.model.BannerWithMeasurers;
import ru.yandex.direct.core.entity.banner.type.measurers.model.BannerMeasurerParamsMoat;
import ru.yandex.direct.core.entity.campaign.model.CampaignMeasurer;
import ru.yandex.direct.core.entity.campaign.model.CampaignMeasurerSystem;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.Collections.emptySet;
import static java.util.function.Function.identity;
import static ru.yandex.direct.utils.CommonUtils.nvl;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;
import static ru.yandex.direct.utils.JsonUtils.fromJson;
import static ru.yandex.direct.utils.JsonUtils.toJson;

@ParametersAreNonnullByDefault
public class BannerWithMeasurersUtils {
    private BannerWithMeasurersUtils() {
    }

    public static boolean isBannerMeasurersChanged(@Nonnull AppliedChanges<? extends BannerWithMeasurers> ac) {
        Set<BannerMeasurer> oldMeasurers = normalizeMeasurers(ac.getOldValue(BannerWithMeasurers.MEASURERS));
        Set<BannerMeasurer> newMeasurers = normalizeMeasurers(ac.getNewValue(BannerWithMeasurers.MEASURERS));
        return !Objects.equals(oldMeasurers, newMeasurers);
    }

    private static Set<BannerMeasurer> normalizeMeasurers(@Nullable List<BannerMeasurer> measurers) {
        return nvl(listToSet(measurers, identity()), emptySet());
    }

    public static void setMoatUseUnstableScript(List<BannerMeasurer> measurers) {
        if (measurers == null) {
            return;
        }
        for (BannerMeasurer measurer : measurers) {
            if (measurer.getBannerMeasurerSystem().equals(BannerMeasurerSystem.MOAT)) {
                BannerMeasurerParamsMoat params = fromJson(measurer.getParams(), BannerMeasurerParamsMoat.class);
                params.setUseUnstableScript(true);
                measurer.setParams(toJson(params));
            }
        }
    }

    public static void setCampMoatUseUnstableScript(List<CampaignMeasurer> measurers) {
        if (measurers == null) {
            return;
        }
        for (CampaignMeasurer measurer : measurers) {
            if (measurer.getMeasurerSystem().equals(CampaignMeasurerSystem.MOAT)) {
                BannerMeasurerParamsMoat params = fromJson(measurer.getParams(), BannerMeasurerParamsMoat.class);
                params.setUseUnstableScript(true);
                measurer.setParams(toJson(params));
            }
        }
    }

}
