package ru.yandex.direct.core.entity.banner.type.measurers;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerMeasurer;
import ru.yandex.direct.core.entity.banner.model.BannerWithMeasurers;
import ru.yandex.direct.core.entity.client.model.ClientMeasurerSystem;
import ru.yandex.direct.core.entity.client.service.ClientMeasurerSettingsService;
import ru.yandex.direct.core.entity.client.service.MediascopeClientSettingsService;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.model.BannerMeasurerSystem.MEDIASCOPE;

@Component
public class BannerWithMeasurersValidatorProvider {

    private final ClientMeasurerSettingsService clientMeasurerSettingsService;
    private final MediascopeClientSettingsService mediascopeClientSettingsService;

    public BannerWithMeasurersValidatorProvider(
            ClientMeasurerSettingsService clientMeasurerSettingsService,
            MediascopeClientSettingsService mediascopeClientSettingsService
    ) {
        this.clientMeasurerSettingsService = clientMeasurerSettingsService;
        this.mediascopeClientSettingsService = mediascopeClientSettingsService;
    }

    public Validator<BannerWithMeasurers, Defect> bannerWithMeasurersValidator() {
        return new BannerMeasurersValidator();
    }

    public Validator<BannerWithMeasurers, Defect> bannerWithMeasurersMediascopeAuthValidator(Long clientId) {
        return bannerWithMeasurers -> {
            var vb = ModelItemValidationBuilder.of(bannerWithMeasurers);
            vb.list(bannerWithMeasurers.getMeasurers(), BannerWithMeasurers.MEASURERS.name())
                    .checkEach(validMediascopeClientSettings(clientId));
            return vb.getResult();
        };
    }

    public Constraint<BannerMeasurer, Defect> validMediascopeClientSettings(Long clientId) {
        return measurer -> {
            if (MEDIASCOPE.equals(measurer.getBannerMeasurerSystem())) {
                var clientSettings =
                        clientMeasurerSettingsService.getByClientIdAndSystem(clientId, ClientMeasurerSystem.MEDIASCOPE);
                if (clientSettings == null || mediascopeClientSettingsService.isExpired(clientSettings.getSettings())) {
                    return CommonDefects.invalidValue();
                }
            }

            return null;
        };
    }
}
