package ru.yandex.direct.core.entity.banner.type.mobilecontent;

import ru.yandex.direct.core.entity.trustedredirects.service.TrustedRedirectsService;
import ru.yandex.direct.core.entity.uac.service.trackingurl.TrackingUrlParseService;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.href.BannerWithHrefConstraints.validImpressionUrl;

public class BannerImpressionUrlValidator implements Validator<String, Defect> {

    private final TrustedRedirectsService trustedRedirectsService;
    private final TrackingUrlParseService trackingUrlParseService;
    private final String trackingUrl;

    public BannerImpressionUrlValidator(TrustedRedirectsService trustedRedirectsService,
                                        TrackingUrlParseService trackingUrlParseService, String trackingUrl) {
        this.trustedRedirectsService = trustedRedirectsService;
        this.trackingUrlParseService = trackingUrlParseService;
        this.trackingUrl = trackingUrl;
    }

    @Override
    public ValidationResult<String, Defect> apply(String url) {
        ItemValidationBuilder<String, Defect> builder = ItemValidationBuilder.of(url);
        return builder
                .check(validImpressionUrl(trustedRedirectsService, trackingUrlParseService, trackingUrl))
                .getResult();
    }
}
