package ru.yandex.direct.core.entity.banner.type.mobilecontent;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersModerationContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithMobileContent;
import ru.yandex.direct.core.entity.banner.model.NewReflectedAttribute;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static com.google.common.base.Preconditions.checkNotNull;
import static ru.yandex.direct.core.entity.banner.model.BannerWithMobileContent.REFLECTED_ATTRIBUTES;


@Component
public class BannerWithMobileContentUpdateOperationTypeSupport extends AbstractBannerUpdateOperationTypeSupport<BannerWithMobileContent> {

    @Override
    public Class<BannerWithMobileContent> getTypeClass() {
        return BannerWithMobileContent.class;
    }

    @Override
    public void onChangesApplied(BannersUpdateOperationContainer updateContainer,
                                 List<AppliedChanges<BannerWithMobileContent>> appliedChanges) {
        mergeReflectedAttrMaps(appliedChanges);
    }

    /**
     * Накладывает маску изменений ReflectedAttrs на исходное значение в базе
     */
    private void mergeReflectedAttrMaps(List<AppliedChanges<BannerWithMobileContent>> appliedChanges) {
        appliedChanges.stream()
                .filter(ac -> ac.changed(REFLECTED_ATTRIBUTES))
                .forEach(ac -> {
                    Map<NewReflectedAttribute, Boolean> oldValues = ac.getOldValue(REFLECTED_ATTRIBUTES);
                    Map<NewReflectedAttribute, Boolean> newValues = ac.getNewValue(REFLECTED_ATTRIBUTES);
                    checkNotNull(oldValues,
                            "ReflectedAttrs old value in changes should contain map of all the flags "
                                    + "with a boolean signifying if the flag is on or off");
                    checkNotNull(newValues,
                            "ReflectedAttrs new value in changes should contain map of any flags whose "
                                    + "value has changed, and a new value, or empty map in case there are no changes");
                    Map<NewReflectedAttribute, Boolean> mergedValues = new EnumMap<>(NewReflectedAttribute.class);
                    mergedValues.putAll(newValues);
                    oldValues.forEach((attr, onOff) ->
                            mergedValues.merge(attr, onOff, (newValue, oldValue) -> newValue));
                    ac.modify(REFLECTED_ATTRIBUTES, mergedValues);
                });
    }

    @Override
    public boolean needModeration(BannersModerationContainer container,
                                  AppliedChanges<BannerWithMobileContent> appliedChanges) {
        return appliedChanges.changed(BannerWithMobileContent.PRIMARY_ACTION);
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithMobileContent> appliedChanges) {
        return appliedChanges.changed(BannerWithMobileContent.PRIMARY_ACTION)
                || appliedChanges.changed(REFLECTED_ATTRIBUTES);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithMobileContent> appliedChanges) {
        return appliedChanges.changed(BannerWithMobileContent.PRIMARY_ACTION)
                || appliedChanges.changed(REFLECTED_ATTRIBUTES);
    }
}
