package ru.yandex.direct.core.entity.banner.type.mobilecontent;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithMobileContent;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithMobileContentUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithMobileContent> {


    private final BannerWithMobileContentValidatorProvider validatorProvider;

    @Autowired
    public BannerWithMobileContentUpdateValidationTypeSupport(BannerWithMobileContentValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithMobileContent> getTypeClass() {
        return BannerWithMobileContent.class;
    }

    @Override
    public ValidationResult<List<BannerWithMobileContent>, Defect> validate(
            BannersUpdateOperationContainer container, ValidationResult<List<BannerWithMobileContent>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithMobileContentValidator(container))
                .getResult();
    }
}
