package ru.yandex.direct.core.entity.banner.type.mobilecontent;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;

import javax.annotation.Nullable;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.banner.model.NewReflectedAttribute;

import static java.util.stream.Collectors.joining;
import static org.apache.commons.lang3.StringUtils.isBlank;

public class BannerWithMobileContentUtils {
    private BannerWithMobileContentUtils() {
    }

    public static String reflectedAttrsToDbConverter(@Nullable Map<NewReflectedAttribute, Boolean> attrs) {
        return attrs == null ? "" :
                attrs.entrySet().stream()
                        .filter(Map.Entry::getValue)
                        .map(e -> e.getKey().getTypedValue())
                        .collect(joining(","));
    }

    public static Map<NewReflectedAttribute, Boolean> reflectedAttrsFromDbConverter(String value) {
        if (isBlank(value)) {
            return convertToMap(EnumSet.allOf(NewReflectedAttribute.class), false);
        }

        EnumSet<NewReflectedAttribute> on = EnumSet.copyOf(
                StreamEx.split(value, ",")
                        .map(NewReflectedAttribute::fromTypedValue)
                        .toSet());
        Map<NewReflectedAttribute, Boolean> result = convertToMap(on, true);
        result.putAll(convertToMap(EnumSet.complementOf(on), false));
        return result;
    }

    private static Map<NewReflectedAttribute, Boolean> convertToMap(EnumSet<NewReflectedAttribute> keys,
                                                                    Boolean value) {
        EnumMap<NewReflectedAttribute, Boolean> map = new EnumMap<>(NewReflectedAttribute.class);
        for (NewReflectedAttribute key : keys) {
            map.put(key, value);
        }
        return map;
    }
}
