package ru.yandex.direct.core.entity.banner.type.mobilecontent;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithMobileContent;
import ru.yandex.direct.core.entity.banner.model.MobileAppBanner;
import ru.yandex.direct.core.entity.banner.type.href.BannerHrefValidator;
import ru.yandex.direct.core.entity.banner.type.href.BannerTrackingHrefMacrosValidator;
import ru.yandex.direct.core.entity.trustedredirects.service.TrustedRedirectsService;
import ru.yandex.direct.core.entity.uac.service.trackingurl.TrackingUrlParseService;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.model.BannerWithMobileContent.IMPRESSION_URL;

@Component
public class BannerWithMobileContentValidatorProvider {

    private final TrustedRedirectsService trustedRedirectsService;
    private final TrackingUrlParseService trackingUrlParseService;

    @Autowired
    public BannerWithMobileContentValidatorProvider(TrustedRedirectsService trustedRedirectsService,
                                                    TrackingUrlParseService trackingUrlParseService) {
        this.trustedRedirectsService = trustedRedirectsService;
        this.trackingUrlParseService = trackingUrlParseService;
    }

    public Validator<BannerWithMobileContent, Defect> bannerWithMobileContentValidator(BannersOperationContainer container) {
        return bannerWithMobileContent -> {
            ModelItemValidationBuilder<BannerWithMobileContent> ivb = ModelItemValidationBuilder.of(bannerWithMobileContent);
            ivb.item(IMPRESSION_URL)
                    .checkBy(impressionUrlValidator(bannerWithMobileContent, container));
            return ivb.getResult();
        };
    }

    private Validator<String, Defect> impressionUrlValidator(BannerWithMobileContent banner,
                                                             BannersOperationContainer container) {
        if (banner instanceof MobileAppBanner) {
            String trackingUrl = ((MobileAppBanner) banner).getHref();
            return impressionUrl -> {
                ItemValidationBuilder<String, Defect> builder = ItemValidationBuilder.of(impressionUrl);
                builder
                        .checkBy(new BannerHrefValidator())
                        .checkBy(new BannerImpressionUrlValidator(
                                trustedRedirectsService, trackingUrlParseService, trackingUrl), When.isValid())
                        .checkBy(new BannerTrackingHrefMacrosValidator(),
                                When.isValidAnd(When.isTrue(container.isValidateTrackingHrefMacros())));
                return builder.getResult();
            };
        }
        return new BannerHrefValidator();
    }
}
