package ru.yandex.direct.core.entity.banner.type.moderation;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.adgroup.model.StatusBLGenerated;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupMappings;
import ru.yandex.direct.core.entity.banner.model.BannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerDisplayHrefStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusSitelinksModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatuses;
import ru.yandex.direct.core.entity.banner.model.BannerTurboLandingStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerVcardStatusModerate;
import ru.yandex.direct.core.entity.banner.model.NewStatusImageModerate;
import ru.yandex.direct.core.entity.banner.model.StatusBannerImageModerate;
import ru.yandex.direct.core.entity.banner.type.moderation.model.BannerStatusInfo;
import ru.yandex.direct.core.entity.banner.type.system.BannerWithSystemFieldsMappings;
import ru.yandex.direct.core.entity.campaign.model.CampaignStatusModerate;
import ru.yandex.direct.core.entity.campaign.repository.CampaignMappings;
import ru.yandex.direct.dbschema.ppc.enums.AdditionsItemCalloutsStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BannerImagesStatusshow;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.dbschema.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BidsStatusmoderate;
import ru.yandex.direct.dbschema.ppc.tables.Banners;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplier;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplierBuilder;

import static java.util.Collections.emptyList;
import static org.apache.commons.collections4.CollectionUtils.isEmpty;
import static ru.yandex.direct.core.entity.campaign.repository.CampaignRepository.WALLETS;
import static ru.yandex.direct.core.entity.campaign.repository.CampaignRepository.campaignBalance;
import static ru.yandex.direct.dbschema.ppc.Tables.ADDITIONS_ITEM_CALLOUTS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_ADDITIONS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBOLANDINGS;
import static ru.yandex.direct.dbschema.ppc.Tables.BIDS;
import static ru.yandex.direct.dbschema.ppc.Tables.PHRASES;
import static ru.yandex.direct.dbschema.ppc.tables.AdgroupsPerformance.ADGROUPS_PERFORMANCE;
import static ru.yandex.direct.dbschema.ppc.tables.BannerDisplayHrefs.BANNER_DISPLAY_HREFS;
import static ru.yandex.direct.dbschema.ppc.tables.BannerImages.BANNER_IMAGES;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;
import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.tables.Images.IMAGES;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Repository
@ParametersAreNonnullByDefault
public class BannerStatusRepository {

    private static final Field<Boolean> BANNER_HAS_HREF =
            DSL.when(BANNERS.HREF.length().gt(0), true).otherwise(false).as("hasHref");

    private static final Field<BannersPerformanceStatusmoderate> VIDEO_ADDITIONS_STATUS_MODERATE =
            DSL.when(BANNERS.BANNER_TYPE.eq(BannersBannerType.text), BANNERS_PERFORMANCE.STATUS_MODERATE)
                    .as("videoAdditionsStatusModerate");

    /**
     * Специальный статус для креативов, которые целиком представляют собой объявление(cpc_video, image_ad, cpm_banner)
     */
    private static final Field<BannersPerformanceStatusmoderate> BANNER_BASED_ON_CREATIVE_STATUS_MODERATE =
            DSL.when(BANNERS.BANNER_TYPE
                            .in(BannersBannerType.cpc_video, BannersBannerType.image_ad, BannersBannerType.cpm_banner),
                    BANNERS_PERFORMANCE.STATUS_MODERATE)
                    .as("bannerBasedOnCreativeStatusModerate");

    private static final Field<Boolean> KEYWORDS_DECLINED = DSL.when(DSL.count(
            DSL.when(BIDS.STATUS_MODERATE.isNotNull().and(BIDS.STATUS_MODERATE.eq(BidsStatusmoderate.No)),
                    1)).gt(0), true).otherwise(false).as("keywordsDeclined");

    private static final Field<Boolean> ADDITIONS_CALLOUTS_DECLINED = DSL.when(
            DSL.count(DSL.when(ADDITIONS_ITEM_CALLOUTS.STATUS_MODERATE.isNotNull()
                    .and(ADDITIONS_ITEM_CALLOUTS.STATUS_MODERATE.eq(AdditionsItemCalloutsStatusmoderate.No)), 1))
                    .gt(0), true)
            .otherwise(false)
            .as("additionsCalloutsDeclined");


    private final JooqReaderWithSupplier<BannerStatuses> bannerWithStatusesReader;
    private final DslContextProvider dslContextProvider;


    @Autowired
    BannerStatusRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;

        bannerWithStatusesReader = JooqReaderWithSupplierBuilder.builder(BannerStatuses::new)
                // баннер
                .readProperty(BannerStatuses.ID,
                        fromField(Banners.BANNERS.BID))
                .readProperty(BannerStatuses.ADGROUP_ID,
                        fromField(PHRASES.PID))
                .readProperty(BannerStatuses.BS_BANNER_ID,
                        fromField(Banners.BANNERS.BANNER_ID))
                .readProperty(BannerStatuses.BANNER_TYPE,
                        fromField(Banners.BANNERS.BANNER_TYPE))
                .readProperty(BannerStatuses.BANNER_STATUS_MODERATE,
                        fromField(Banners.BANNERS.STATUS_MODERATE)
                                .by(BannerStatusModerate::fromSource))
                .readProperty(BannerStatuses.BANNER_STATUS_POST_MODERATE,
                        fromField(Banners.BANNERS.STATUS_POST_MODERATE)
                                .by(BannerStatusPostModerate::fromSource))
                .readProperty(BannerStatuses.BANNER_STATUS_BS_SYNCED,
                        fromField(Banners.BANNERS.STATUS_BS_SYNCED).by(BannerWithSystemFieldsMappings::statusBsSyncedFromDb))
                .readProperty(BannerStatuses.BANNER_STATUS_ARCH,
                        fromField(Banners.BANNERS.STATUS_ARCH).by(BannerWithSystemFieldsMappings::statusArchivedFromDb))
                .readProperty(BannerStatuses.BANNER_STATUS_SHOW,
                        fromField(Banners.BANNERS.STATUS_SHOW).by(BannerWithSystemFieldsMappings::statusShowFromDb))
                .readProperty(BannerStatuses.BANNER_STATUS_ACTIVE,
                        fromField(Banners.BANNERS.STATUS_ACTIVE).by(BannerWithSystemFieldsMappings::statusActiveFromDb))
                .readProperty(BannerStatuses.BANNER_PHONE_FLAG,
                        fromField(Banners.BANNERS.PHONEFLAG).by(BannerVcardStatusModerate::fromSource))
                .readProperty(BannerStatuses.BANNER_STATUS_SITELINKS_MODERATE,
                        fromField(Banners.BANNERS.STATUS_SITELINKS_MODERATE)
                                .by(BannerStatusSitelinksModerate::fromSource))
                .readProperty(BannerStatuses.BANNER_DISPLAY_HREF_STATUS_MODERATE,
                        fromField(BANNER_DISPLAY_HREFS.STATUS_MODERATE).by(BannerDisplayHrefStatusModerate::fromSource))
                .readProperty(BannerStatuses.BANNER_STATUS_IMAGE_MODERATE,
                        fromField(BANNER_IMAGES.STATUS_MODERATE).by(StatusBannerImageModerate::fromSource))
                .readProperty(BannerStatuses.BANNER_IMAGE_AD_STATUS_MODERATE,
                        fromField(IMAGES.STATUS_MODERATE).by(NewStatusImageModerate::fromSource))
                .readProperty(BannerStatuses.BANNER_TURBOLANDING_STATUS_MODERATE,
                        fromField(BANNER_TURBOLANDINGS.STATUS_MODERATE)
                                .by(BannerTurboLandingStatusModerate::fromSource))
                .readProperty(BannerStatuses.BANNER_BASED_ON_CREATIVE_STATUS_MODERATE,
                        fromField(BANNER_BASED_ON_CREATIVE_STATUS_MODERATE)
                                .by(BannerCreativeStatusModerate::fromSource))
                .readProperty(BannerStatuses.VIDEO_ADDITIONS_STATUS_MODERATE,
                        fromField(VIDEO_ADDITIONS_STATUS_MODERATE).by(BannerCreativeStatusModerate::fromSource))
                .readProperty(BannerStatuses.BANNER_HAS_HREF,
                        fromField(BANNER_HAS_HREF))
                .readProperty(BannerStatuses.ADDITIONS_CALLOUTS_DECLINED,
                        fromField(ADDITIONS_CALLOUTS_DECLINED))

                // ключевые фразы
                .readProperty(BannerStatuses.KEYWORDS_DECLINED,
                        fromField(KEYWORDS_DECLINED))

                // группа
                .readProperty(BannerStatuses.ADGROUP_STATUS_MODERATE,
                        fromField(PHRASES.STATUS_MODERATE)
                                .by(ru.yandex.direct.core.entity.adgroup.model.StatusModerate::fromSource))
                .readProperty(BannerStatuses.ADGROUP_STATUS_POST_MODERATE,
                        fromField(PHRASES.STATUS_POST_MODERATE)
                                .by(ru.yandex.direct.core.entity.adgroup.model.StatusPostModerate::fromSource))
                .readProperty(BannerStatuses.ADGROUP_STATUS_BS_SYNCED,
                        fromField(PHRASES.STATUS_BS_SYNCED).by(AdGroupMappings::statusBsSyncedFromDb))
                .readProperty(BannerStatuses.ADGROUP_PERFORMANCE_STATUS_B_L_GENERATED,
                        fromField(ADGROUPS_PERFORMANCE.STATUS_BL_GENERATED).by(StatusBLGenerated::fromSource))

                // кампания
                .readProperty(BannerStatuses.CAMPAIGN_SUM_TO_PAY,
                        fromField(CAMPAIGNS.SUM_TO_PAY))
                .readProperty(BannerStatuses.CAMPAIGN_STATUS_MODERATE,
                        fromField(CAMPAIGNS.STATUS_MODERATE).by(CampaignStatusModerate::fromSource))
                .readProperty(BannerStatuses.CAMPAIGN_STATUS_SHOW,
                        fromField(CAMPAIGNS.STATUS_SHOW).by(CampaignMappings::statusShowFromDb))
                .readProperty(BannerStatuses.CAMPAIGN_BALANCE,
                        fromField(campaignBalance(CAMPAIGNS, WALLETS).as("campaignBalance")))
                .build();
    }

    public List<BannerStatusInfo> getBannersStatusInfo(int shard, Collection<Long> bannerIds) {
        if (isEmpty(bannerIds)) {
            return emptyList();
        }
        return dslContextProvider.ppc(shard)
                .select(bannerWithStatusesReader.getFieldsToRead())
                .from(BANNERS)
                .leftJoin(PHRASES).on(BANNERS.PID.eq(PHRASES.PID))
                .leftJoin(BIDS).on(BANNERS.PID.eq(BIDS.PID))
                .leftJoin(BANNERS_PERFORMANCE).on(BANNERS.BID.eq(BANNERS_PERFORMANCE.BID)
                        .and(BANNERS.PID.eq(BANNERS_PERFORMANCE.PID))
                        .and(BANNERS.CID.eq(BANNERS_PERFORMANCE.CID)))
                .leftJoin(BANNER_TURBOLANDINGS).on(BANNERS.BID.eq(BANNER_TURBOLANDINGS.BID))
                .leftJoin(BANNER_DISPLAY_HREFS).on(BANNERS.BID.eq(BANNER_DISPLAY_HREFS.BID))
                .leftJoin(BANNER_IMAGES).on(BANNERS.BID.eq(BANNER_IMAGES.BID)
                        .and(BANNER_IMAGES.STATUS_SHOW.eq(BannerImagesStatusshow.Yes)))
                .leftJoin(IMAGES).on(BANNERS.BID.eq(IMAGES.BID)
                        .and(BANNERS.PID.eq(IMAGES.PID))
                        .and(BANNERS.CID.eq(IMAGES.CID)))
                .leftJoin(ADGROUPS_PERFORMANCE).on(BANNERS.PID.eq(ADGROUPS_PERFORMANCE.PID))
                .leftJoin(BANNERS_ADDITIONS).on(BANNERS.BID.eq(BANNERS_ADDITIONS.BID))
                .leftJoin(ADDITIONS_ITEM_CALLOUTS)
                .on(BANNERS_ADDITIONS.ADDITIONS_ITEM_ID.eq(ADDITIONS_ITEM_CALLOUTS.ADDITIONS_ITEM_ID))
                .leftJoin(CAMPAIGNS).on(PHRASES.CID.eq(CAMPAIGNS.CID))
                .leftJoin(WALLETS).on(CAMPAIGNS.WALLET_CID.eq(WALLETS.CID))
                .where(BANNERS.BID.in(bannerIds))
                .groupBy(BANNERS.BID)
                .fetch(r -> BannerStatusInfo.getBannerStatusInfo(bannerWithStatusesReader.fromDb(r)));
    }
}
