package ru.yandex.direct.core.entity.banner.type.moderation;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;

import static java.util.function.Function.identity;

@Component
public class BannerWithModerationStatusesAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithModerationStatuses> {

    private final DefaultAddOperationModerationProcessor defaultProcessor;
    private final Map<Class, AddOperationModerationProcessor> processors;

    @Autowired
    @SuppressWarnings("Convert2MethodRef")
    public BannerWithModerationStatusesAddOperationTypeSupport(
            DefaultAddOperationModerationProcessor defaultProcessor,
            List<AddOperationModerationProcessor> processors) {
        this.defaultProcessor = defaultProcessor;
        this.processors = StreamEx.of(processors)
                .remove(processor -> processor instanceof DefaultAddOperationModerationProcessor)
                .mapToEntry(processor -> processor.getProcessedClass(), identity())
                .toMap();
    }

    @Override
    public Class<BannerWithModerationStatuses> getTypeClass() {
        return BannerWithModerationStatuses.class;
    }

    @Override
    public void addToAdditionalActionsContainer(BannerAdditionalActionsContainer additionalActionsContainer,
                                                BannersAddOperationContainer container,
                                                List<BannerWithModerationStatuses> banners) {
        banners.forEach(banner -> processBanner(additionalActionsContainer, container, banner));
    }

    @SuppressWarnings("unchecked")
    private <T extends BannerWithModerationStatuses> void processBanner(
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannersAddOperationContainer container,
            T banner) {
        Class<T> bannerClass = ((Class<T>) banner.getClass());
        AddOperationModerationProcessor processor = getProcessor(bannerClass);
        processor.process(additionalActionsContainer, container, banner);
    }

    private AddOperationModerationProcessor getProcessor(Class bannerClass) {
        AddOperationModerationProcessor processor = processors.get(bannerClass);
        return processor != null ? processor : defaultProcessor;
    }
}
