package ru.yandex.direct.core.entity.banner.type.moderation;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;
import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;

import static ru.yandex.direct.core.entity.banner.type.moderation.ContentPromotionBannersAutoModerationPropsHolder.AUTO_MODERATED_API_ONLY_CONTENT_PROMOTION_TYPES;

@Component
public class ContentPromotionAddOperationModerationProcessor
        implements AddOperationModerationProcessor<ContentPromotionBanner> {

    private final ContentPromotionBannersAutoModerationPropsHolder autoModerationPropsHolder;
    private final DefaultAddOperationModerationProcessor defaultAddOperationModerationProcessor;

    @Autowired
    public ContentPromotionAddOperationModerationProcessor(
            PpcPropertiesSupport ppcPropertiesSupport,
            DefaultAddOperationModerationProcessor defaultAddOperationModerationProcessor) {
        this.autoModerationPropsHolder = new ContentPromotionBannersAutoModerationPropsHolder(ppcPropertiesSupport);
        this.defaultAddOperationModerationProcessor = defaultAddOperationModerationProcessor;
    }

    @Override
    public Class<ContentPromotionBanner> getProcessedClass() {
        return ContentPromotionBanner.class;
    }

    @Override
    public void process(BannerAdditionalActionsContainer additionalActionsContainer,
                        BannersAddOperationContainer container,
                        BannerWithModerationStatuses banner) {
        // Сначала вызываем дефолтную логику для статусов модерации и переотправки групп и кампаний
        defaultAddOperationModerationProcessor.process(additionalActionsContainer, container, banner);

        // А затем при определенных условиях переопределяем статусы и добавляем переотправляемые объекты

        CommonCampaign campaign = container.getCampaign(banner);
        ContentPromotionAdgroupType contentPromotionAdgroupType = container.getContentPromotionAdGroupType(banner);
        // todo valid adGroup type?
        boolean isContentPromotionAutoModeratedBanner = autoModerationPropsHolder
                .isBannerContentPromotionAndAutoModerated(AdGroupType.CONTENT_PROMOTION, contentPromotionAdgroupType);

        if (isContentPromotionAutoModeratedBanner) {
            banner
                    .withStatusModerate(BannerStatusModerate.YES)
                    .withStatusPostModerate(BannerStatusPostModerate.YES);

            if (AUTO_MODERATED_API_ONLY_CONTENT_PROMOTION_TYPES.contains(contentPromotionAdgroupType)) {
                additionalActionsContainer.addAdGroupIdForRemoderation(banner.getAdGroupId());
                additionalActionsContainer.addCampaignIdForRemoderationForContentPromotion(campaign.getId());
            }
        }
    }
}
